<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductStationTank extends Model 
{

    protected $table = 'product_station_tanks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('product_id', 'service_station_id', 'pistolets');
    protected $visible = array('product_id', 'service_station_id', 'pistolets');

    public function tanks()
    {
        return $this->hasMany('Tank');
    }

    public function service_station()
    {
        return $this->belongsTo('ServiceStation', 'service_station_id');
    }

    public function product()
    {
        return $this->belongsTo('Product', 'product_id');
    }

}